#ifndef VARIABLES_INVIT
#define VARIABLES_INVIT

#include <allegro.h>
#include <stdio.h>
#include <math.h>
#include "sprites.h"

char pong_error[256]; //on met l'erreur dedans!
int game_state; // L'ETAT DU JEU

int close_state;  //TRUE ou FALSE FALSE PAR DEFAUT bien sur;) TRUE des que l'utilisateur clique en haut  droite dela fenetre sur la croix

#define TPONG_VERSION "1.1 MINI"


//POUR LE MENU:
#define IN_MENU  1
#define PLAYING_THE_GAME  2
#define ASKING_PLAYER_NAME 3
#define IN_OPTION_MENU	4
#define IN_MODE_SELECTOR_MENU 5

#define MENU_NEW_GAME_DUEL_CLASSIC  0
#define MENU_NEW_GAME_DUEL_2P       1
#define MENU_NEW_GAME_DUEL_2AI      2
#define MENU_NEW_GAME_2P_VS_AI      3
#define MENU_OPTIONS                4
#define MENU_QUIT_THE_GAME          5
#define MENU_NB_SELECTIONS          6

#define OPTION_MENU_DEFINE_GAME_MODE   0
#define OPTION_MENU_PL		            1
#define OPTION_MENU_PL1		            2
#define OPTION_MENU_PL2		            3
#define OPTION_MENU_RETURN		         4
#define OPTION_MENU_NB_SELECTIONS	   5

#define MODE_SELECTOR_MENU_REGULAR        0
#define MODE_SELECTOR_MENU_HARD           1
#define MODE_SELECTOR_MENU_UNLIMITED      2
#define MODE_SELECTOR_MENU_RETURN		   3
#define MODE_SELECTOR_MENU_NB_SELECTIONS	4


//MATHS 
#ifndef PI 
   #define PI 3.14159265359
#endif

//macro qui convertie un angle en radian en un angle de valeur 0 -> 256
#define RAD_TO_256_ANGLE(x) 40.7436654315*x
#define RAD_TO_DEGREE(x) 57.2957795131*x

//AFFICHAGE

//OPTIONS VIDEO
int gfx_w;//la rsolution de l'cran
int gfx_h;
int color_depth;//la rsolution par pixel
int WINDOWED;//si on veut en mode fenetre!
int ENABLE_VSYNC;//TRUE OU FALSE

#define DOUBLE_BUFFER 1
#define PAGE_FLIPPING 2
#define TRIPLE_BUFFER 3


//pour le triple buffer
BITMAP *page1;
BITMAP *page2;
BITMAP *page3;

BITMAP *buffer;   //c'est le buffer ou l'on affiche quel que soit le mode d'affichage

int current_page; //la page courante pour le page flipping /triple buffering
int draw_method;  //la mthode d'affichage

//CE QUE RETOURNE LA FONCTION DU JEU
#define QUIT_THE_GAME -1
#define LEVEL_COMPLETED 2
#define RETURN_MAIN_MENU 3



//POUR LE JEU
#define HUMAN 1
#define AI 2
#define LEFT -1
#define NOT_DEFINED 0
#define CENTRE 0
#define RIGHT 1
#define POSITION_TOP -1			//LOGIQUE coin suprieur gauche en origine et axe y vers le bas
#define POSITION_BOTTOM 1

//Des modes de jeu trs spciaux...
#define GAME_MODE_REGULAR  0
#define GAME_MODE_MINI     1


int game_type;//le type de jeu
#define DUEL_2P 1
#define DUEL_2AI 2
#define DUEL   3
#define DUEL_2P_VS_AI   4


//constantes du jeu
#define START_BALL_SPEED_X 0.25
#define START_BALL_SPEED_Y 0.025
#define START_BALL_X  60
#define START_BALL_Y  SCREEN_H/2
#define FIRST_SIDE_TO_HIT  RIGHT

#define INTERVAL_RACKET_X	10
#define RACKET_ACC_Y  0.01
#define RACKET_DEC_Y  0.002
#define RACKET_MAX_SPEED_Y 0.5

//EFFETS SPECIAUX
#define NB_GAME_STARS   300 //le Nombre d'toiles dans le jeu
#define STAR_START_Z    15
#define STAR_START_SPEED   0.01
#define STAR_START_RADIUS_X   (SCREEN_W*8)
#define STAR_START_RADIUS_Y   (SCREEN_H*8)

#define FACTOR_SPEED_STAR 0.005

#define SHOW_SCORE_TIME 3

#define NB_MAX_SPARKS         150
#define NB_MAX_SPARKS_RACKET  16
#define MAX_SPARK_LIFE        2000
#define SPARK_RACKET          0
#define SPARK_BORDER          1

#define SPARK_BORDER_RADIUS_ANGLE_RAND  100
#define SPARK_BORDER_DIVISOR_ANGLE_RAND 300.0
#define SPARK_RACKET_RADIUS_ANGLE_RAND  100
#define SPARK_RACKET_DIVISOR_ANGLE_RAND 200.0

#define SPARK_SPEED_RAND   100
#define SPARK_SPEED_DIVISOR_RAND 200.0
#define SPARK_SPEED_MIN_ADDED 0.25



//SONS
//Pas de musiques pour l'instant
int sfx_on;//si le son est actif ou pas
int sfx_volume;//volume du son
int reverse_stereo;//TRUE si on inverse la stro sinon FALSE.

//TEMPS REEL->SCORE
volatile unsigned long current_score;//combien le joueur fait en ce moment
volatile int game_time;//la variable qui controle le temps rel
double game_speed;//la variable (constante en fait) pour la vitesse du jeu
volatile unsigned long current_sec_counter;
int current_fps;
int fps;

//CLAVIER (si une touche est actuellement appuye)
//j'ai vu qu'il y a une fonction qui fait a toute seule, ca pourait me simplifier mon code ;)
int key_pressed;

//TABLEAU DE SCORE
#define SIZE_HIGH_SCORE_TABLE 5
#define MAX_NAME_LENGTH 15

char *name;

//FILES
FILE *fp; //logfile handler
PACKFILE* high_score;//la table des high scores

DATAFILE *data_sprite;//notre fichier data pour les sprites
DATAFILE *data_sfx;//notre fichier data pour les sons.
DATAFILE *data_fonts;//notre fichier data pour les fonts

//LE JEU
#define PLAYER_1 0
#define PLAYER_2 1

int nb_max_players;//Le nombre de joueurs max!
int nb_max_balls;//le nombre de balles maximum
int nb_current_balls;//le nombre de balles courantes

typedef struct {
   int key_up;
   int key_down;
} TPONG_CONFIG_PLAYER;

typedef struct {
   double x;
   double y;
} VECTOR;

typedef struct {
   double x;
   double y;
   double z;
} VECTOR_3D;


typedef struct {
   unsigned long score;
   char name[MAX_NAME_LENGTH];
} HIGH_SCORE_ENTRY;

typedef struct {
   char path_name[256];          //le path du fichier de high score
   int nb_high_score_entries;          //le nombre d'entres du tableau des high scores.
   HIGH_SCORE_ENTRY* high_score_entry; //le tableau des entres des high scores
} HIGH_SCORE;


typedef struct {
	int circle_radius;          //Le rayon des deux cercles qui composent la raquette
	int circle_centre_interval; //La distance entre le centre et chaque centre de cercle extrme.
   BITMAP* main_bitmap;        //un bitmap, tout de mme!
   BITMAP* top_bitmap;         //bitmap suprieur
   BITMAP* bottom_bitmap;      //bitmap infrieur
   VECTOR position;          	 //vecteur position
   VECTOR speed;             	 //vecteur vitesse
   int IS_MOVING;            	 //si la raquette est actuellement bouge par le joueur
   int IS_WAITING_FOR_PITCH; 	 //si la raquette attend pour mettre un effet  la balle
   VECTOR wait_position;     	 //la position d'attente.
} RACKET;                    	 //C'est la raquette

typedef struct {
   int name_pos;          //LEFT, RIGHT or CENTER pour afficher le nom
   char name[255];        //le nom du bouton
   char des[255];         //la description de l'option choisie
   VECTOR pos;            //la position sur l'cran
} TPONG_MENU_ELEMENT;     //L'lment du menu

typedef struct {
   int nb_elements;              //le nombre d'lments du menu
   TPONG_MENU_ELEMENT* element;  //les pointeurs vers les lments du menu
   int cur_selection;            //la selection courante!
   //faire un pointeur vers une fonction pour dessiner ce menu!
  
} TPONG_MENU;

typedef struct {
   int EXIST;           //TRUE OR FALSE
   BITMAP *bitmap;      //un bitmap tout de mme!
   VECTOR position;     //vecteur position
   VECTOR speed;        //vecteur vitesse
   int next_side_to_hit;
} BALL;                 //c'est la balle

typedef struct {
   int pos;                //LEFT OR RIGHT
   int state;              //HUMAN OR AI
   RACKET *racket;         //pointeur vers UNE raquette
   int nb_lives;           //le nombre de vies
   unsigned long score;    //le score actuel
   int key_up, key_down;   //les touches pour monter/descendre
} PLAYER;


typedef struct {
   int winning_side;             //LEFT ou RIGHT bien sur
   unsigned long nb_left_wins;
   unsigned long nb_right_wins;
   unsigned long last_score;     //le dernier temps effectu   
   int new_hiscore_pos;          //la nouvelle position dans le hi-score pour le mode DUEL seulement
} INFO_2P_GAME;                  //une structure d'info sur le jeu  2 joueurs autre que le mode DUEL

typedef struct {
   int index;                    //pour la sauvegarde
   VECTOR max_ball_speed;
   char name[128];
   HIGH_SCORE high_score;        //le high score du niveau de jeu ;)
   BITMAP* logo_bitmap;          //le logo qui symbolise le niveau dans le jeu
} LEVEL_DIFFICULTY;

typedef struct {
   FONT* font_large;             //TEMPORAIRE
   FONT* font_regular;           //TEMPORAIRE
   LEVEL_DIFFICULTY* cur_level;  //pointeur vers le niveau courant   
} GAME;


typedef struct {
   int nb_stars;                 //Le nombre d'toiles. Plus il y en a
   VECTOR_3D* star;              //Tableau  trois dimensions des toiles
   double star_speed;            //la vitesse !
} STARS;


//Les etincelles sont des pixels!
typedef struct {
   VECTOR speed;
   int color;
   VECTOR pos;
   double full_life;             //la vie  t = 0
   double life;                  // si life=0 => mort
   double EXIST;                 //TRUE ou FALSE (= mort)
   int source;                   //RACKET Ou BORDER
} SPARK;

SPARK* spark;                    //LEs tincelles!!



STARS stars;                     //Les effets spciaux lis au jeu->LES ETOILES


GAME game;                       //Une structure d'infos gnrales sur le jeu
INFO_2P_GAME game_info;          //une structure d'info sur le jeu  2 joueurs autre que le mode DUEL
PLAYER **player;                 // un tableau de joueurs
BALL **ball;                     //les pointeurs vers des balles

TPONG_MENU* main_menu;           //Le menu
TPONG_MENU* option_menu;         //Le menu des options
TPONG_MENU* mode_selector_menu;  //Le menu des modes de jeu ;)

TPONG_CONFIG_PLAYER  single_player;
TPONG_CONFIG_PLAYER  left_player;
TPONG_CONFIG_PLAYER  right_player;

LEVEL_DIFFICULTY  l_classic;     //le mode classique avec la vitesses des versions <= 3
LEVEL_DIFFICULTY  l_hard;        //Nouveau et bien plus dur que classique (l'ordi ne perd pas)
LEVEL_DIFFICULTY  l_unlimited;   //Pas de limites de vitesses de la balle ! ;) ouaf ouaf ouaf, le mode des paranos (ou blass mais ca m'tonnerait)



#endif